<?php
/**
 * Main FreePOS admin page template.
 *
 * Expected variables (from FreePOS::render_admin_page):
 * - string $wc_version
 * - array  $gateways
 * - string $gateway_err
 * - string $pos_slug
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="wrap">
	<h1><?php esc_html_e( 'FreePOS – Point of Sale for WooCommerce', 'freepos' ); ?></h1>

	<p>
		<?php
		printf(
			/* translators: %1$s: plugin version, %2$s: WooCommerce version */
			esc_html__( 'FreePOS version %1$s running with WooCommerce version %2$s.', 'freepos' ),
			esc_html( FREEPOS_VERSION ),
			esc_html( $wc_version )
		);
		?>
	</p>

	<h2><?php esc_html_e( 'Available Payment Gateways', 'freepos' ); ?></h2>

	<?php if ( ! empty( $gateway_err ) ) : ?>

		<p><?php echo esc_html( $gateway_err ); ?></p>

	<?php elseif ( empty( $gateways ) ) : ?>

		<p><?php esc_html_e( 'No available payment gateways were detected.', 'freepos' ); ?></p>

	<?php else : ?>

		<table class="widefat striped">
			<thead>
				<tr>
					<th><?php esc_html_e( 'ID', 'freepos' ); ?></th>
					<th><?php esc_html_e( 'Title', 'freepos' ); ?></th>
					<th><?php esc_html_e( 'Description', 'freepos' ); ?></th>
					<th><?php esc_html_e( 'Enabled', 'freepos' ); ?></th>
					<th><?php esc_html_e( 'Supports', 'freepos' ); ?></th>
				</tr>
			</thead>
			<tbody>
				<?php foreach ( $gateways as $gateway_id => $gateway ) : ?>
					<tr>
						<td><?php echo esc_html( $gateway_id ); ?></td>
						<td><?php echo esc_html( $gateway->get_title() ); ?></td>
						<td><?php echo esc_html( $gateway->get_description() ); ?></td>
						<td>
							<?php
							echo ( 'yes' === $gateway->enabled )
								? esc_html__( 'Yes', 'freepos' )
								: esc_html__( 'No', 'freepos' );
							?>
						</td>
						<td>
							<?php
							$supports = (array) $gateway->supports;
							if ( empty( $supports ) ) {
								esc_html_e( '—', 'freepos' );
							} else {
								echo esc_html( implode( ', ', $supports ) );
							}
							?>
						</td>
					</tr>
				<?php endforeach; ?>
			</tbody>
		</table>

	<?php endif; ?>

	<hr />

	<h2><?php esc_html_e( 'POS Screen Settings', 'freepos' ); ?></h2>

	<form method="post" action="options.php">
		<?php settings_fields( 'freepos_settings' ); ?>

		<table class="form-table" role="presentation">
			<tr>
				<th scope="row">
					<label for="freepos_pos_slug">
						<?php esc_html_e( 'POS URL Slug', 'freepos' ); ?>
					</label>
				</th>
				<td>
					<input
						name="freepos_pos_slug"
						type="text"
						id="freepos_pos_slug"
						value="<?php echo esc_attr( $pos_slug ); ?>"
						class="regular-text"
					/>
					<p class="description">
						<?php
						printf(
							/* translators: %s: example URL */
							esc_html__( 'The URL path for the POS screen. Current POS URL: %s', 'freepos' ),
							esc_html( home_url( '/' . $pos_slug . '/' ) )
						);
						?>
					</p>
				</td>
			</tr>
		</table>

		<?php submit_button(); ?>
	</form>

	<hr />

	<p>
		<?php esc_html_e( 'This is the starting point for the FreePOS interface. From here we will add POS screens, inventory tools, and order handling that leverage your installed payment gateways.', 'freepos' ); ?>
	</p>
</div>
