<?php
/**
 * Front-end POS screen template for FreePOS.
 *
 * Expected variables:
 * - string $pos_slug (current POS URL slug)
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

get_header();
?>
<main id="primary" class="freepos-pos-screen">
	<div class="wrap">
		<h1><?php esc_html_e( 'FreePOS – POS Screen', 'freepos' ); ?></h1>

		<p>
			<?php
			printf(
				/* translators: %s: POS URL */
				esc_html__( 'You are viewing the POS screen at %s.', 'freepos' ),
				esc_html( home_url( '/' . $pos_slug . '/' ) )
			);
			?>
		</p>

		<p>
			<?php esc_html_e( 'This is a placeholder for the POS interface. Here we will later add product search, cart management, and payment actions using your configured gateways.', 'freepos' ); ?>
		</p>

		<div class="freepos-pos-layout">
			<div class="freepos-pos-products">
				<h2><?php esc_html_e( 'Products', 'freepos' ); ?></h2>
				<p><?php esc_html_e( 'Product list / search UI will go here.', 'freepos' ); ?></p>
			</div>

			<div class="freepos-pos-cart">
				<h2><?php esc_html_e( 'Cart', 'freepos' ); ?></h2>
				<p><?php esc_html_e( 'Cart items and totals will go here.', 'freepos' ); ?></p>
			</div>

			<div class="freepos-pos-payments">
				<h2><?php esc_html_e( 'Payments', 'freepos' ); ?></h2>
				<p><?php esc_html_e( 'Payment actions using existing gateways will go here.', 'freepos' ); ?></p>
			</div>
		</div>
	</div>
</main>
<?php
get_footer();
