<?php
/**
 * FreePOS settings page template.
 *
 * Expected variables:
 * - string $pos_slug
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>
<div class="wrap">
    <h1><?php esc_html_e( 'FreePOS Settings', 'freepos' ); ?></h1>

    <h2><?php esc_html_e( 'POS Screen Settings', 'freepos' ); ?></h2>

    <form method="post" action="options.php">
        <?php settings_fields( 'freepos_settings' ); ?>

        <table class="form-table" role="presentation">
            <tr>
                <th scope="row">
                    <label for="freepos_pos_slug">
                        <?php esc_html_e( 'POS URL Slug', 'freepos' ); ?>
                    </label>
                </th>
                <td>
                    <input
                        name="freepos_pos_slug"
                        type="text"
                        id="freepos_pos_slug"
                        value="<?php echo esc_attr( $pos_slug ); ?>"
                        class="regular-text"
                    />
                    <p class="description">
                        <?php
                        printf(
                            /* translators: %s: example URL */
                            esc_html__( 'The URL path for the POS screen. Current POS URL: %s', 'freepos' ),
                            esc_html( home_url( '/' . $pos_slug . '/' ) )
                        );
                        ?>
                    </p>
                </td>
            </tr>
        </table>

        <?php submit_button(); ?>
    </form>
</div>
