jQuery(function($) {

    function loadDashboard(range) {

        $.post(ajaxurl, {
            action: 'freepos_dashboard_stats',
            nonce: FreePOS_Admin.nonce,
            range: range
        }, function(res) {

            if (!res.success) return;

            let data = res.data;

            // Update cash balance
            $('.freepos-cash-balance .amount').text(data.cash_balance);

            // Update charts
            updateChart(window.salesChart, data.sales);
            updateChart(window.sellerChart, data.seller);
            updateChart(window.registerChart, data.register);
            updateChart(window.paymentChart, data.payment);

            // Update orders table
            $('#freepos-last-orders-body').html(data.last_orders_html);

        });
    }

    function updateChart(chart, dataset) {
        chart.data = dataset;
        chart.update();
    }

    // Initialize charts (empty)
    window.salesChart = new Chart(document.getElementById('freepos-chart-sales'), { type: 'bar', data: {} });
    window.sellerChart = new Chart(document.getElementById('freepos-chart-seller'), { type: 'bar', data: {} });
    window.registerChart = new Chart(document.getElementById('freepos-chart-register'), { type: 'pie', data: {} });
    window.paymentChart = new Chart(document.getElementById('freepos-chart-payment'), { type: 'pie', data: {} });

    // Date filter button click
    $('.freepos-date-filters button').on('click', function() {
        let range = $(this).data('range');
        loadDashboard(range);
    });

    // Load "Today" by default
    loadDashboard('today');
});
