jQuery(function($) {

    $('#freepos-orders-refresh').on('click', function() {
        freepos_load_orders();
    });

    $('#freepos-orders-search-input').on('keyup', function() {
        freepos_load_orders();
    });

    $('#freepos-orders-per-page').on('change', function() {
        freepos_load_orders();
    });

    function freepos_load_orders() {

        $.post(ajaxurl, {
            action: 'freepos_get_orders',
            nonce: FreePOS_Admin.nonce,
            search: $('#freepos-orders-search-input').val(),
            per_page: $('#freepos-orders-per-page').val()
        }, function(res) {

            if (!res.success) return;

            $('#freepos-orders-body').html(res.data.rows_html);
            $('.freepos-orders-count').text(res.data.count_text);
        });
    }

    // Auto-load
    freepos_load_orders();
});
