jQuery(function($) {

    function loadTransactions() {
        $.post(ajaxurl, {
            action: 'freepos_get_transactions',
            nonce: FreePOS_Admin.nonce,
            type: $('.freepos-transactions-tabs .active').data('type'),
            search: $('#freepos-transactions-search-input').val(),
            per_page: $('#freepos-transactions-per-page').val(),
        }, function(res) {
            if (!res.success) return;

            $('#freepos-transactions-body').html(res.data.rows_html);
            $('.freepos-transactions-count').text(res.data.count_text);
        });
    }

    // Tab switch
    $('.freepos-transactions-tabs .tab').on('click', function() {
        $('.freepos-transactions-tabs .tab').removeClass('active');
        $(this).addClass('active');
        loadTransactions();
    });

    $('#freepos-transactions-search-input').on('keyup', loadTransactions);
    $('#freepos-transactions-per-page').on('change', loadTransactions);
    $('#freepos-transactions-refresh').on('click', loadTransactions);

    loadTransactions();
});
