<?php
/**
 * Admin Dashboard Template for FreePOS
 *
 * Expected:
 *  - You have enqueued Chart.js in the admin (we'll add instructions)
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<div class="wrap freepos-dashboard">

    <h1><?php esc_html_e( 'FreePOS Dashboard', 'freepos' ); ?></h1>

    <!-- Date Filter Buttons -->
    <div class="freepos-date-filters">
        <button class="button button-primary" data-range="today"><?php esc_html_e( 'Today', 'freepos' ); ?></button>
        <button class="button" data-range="yesterday"><?php esc_html_e( 'Yesterday', 'freepos' ); ?></button>
        <button class="button" data-range="this_week"><?php esc_html_e( 'This Week', 'freepos' ); ?></button>
        <button class="button" data-range="last_7"><?php esc_html_e( 'Last 7 Days', 'freepos' ); ?></button>
        <button class="button" data-range="this_month"><?php esc_html_e( 'This Month', 'freepos' ); ?></button>

        <a href="<?php echo esc_url( home_url( '/' . $pos_slug . '/' ) ); ?>" class="button button-primary freepos-goto-pos">
            <?php esc_html_e( 'Goto POS', 'freepos' ); ?>
        </a>
    </div>

    <div class="freepos-dashboard-grid">

        <!-- All Sales -->
        <div class="freepos-card">
            <h2><?php esc_html_e( 'All Sales', 'freepos' ); ?></h2>
            <canvas id="freepos-chart-sales"></canvas>
        </div>

        <!-- Sales By Register -->
        <div class="freepos-card small">
            <h2><?php esc_html_e( 'Sales by Register', 'freepos' ); ?></h2>
            <canvas id="freepos-chart-register"></canvas>
        </div>

        <!-- Sales by Seller -->
        <div class="freepos-card">
            <h2><?php esc_html_e( 'Sales by Seller', 'freepos' ); ?></h2>
            <canvas id="freepos-chart-seller"></canvas>
        </div>

        <!-- Sales By Payment Method -->
        <div class="freepos-card small">
            <h2><?php esc_html_e( 'Sales by Payment', 'freepos' ); ?></h2>
            <canvas id="freepos-chart-payment"></canvas>
        </div>

        <!-- Cash Balance -->
        <div class="freepos-card small freepos-cash-balance">
            <h2><?php esc_html_e( 'Cash Balance', 'freepos' ); ?></h2>
            <div class="amount">$0.00</div>
        </div>

    </div>

    <!-- Last Orders Table -->
    <div class="freepos-card full">
        <h2><?php esc_html_e( 'Last Orders', 'freepos' ); ?></h2>

        <table class="widefat striped freepos-last-orders">
            <thead>
                <tr>
                    <th>#</th>
                    <th><?php esc_html_e( 'Customer', 'freepos' ); ?></th>
                    <th><?php esc_html_e( 'Grand Total', 'freepos' ); ?></th>
                    <th><?php esc_html_e( 'Sale By', 'freepos' ); ?></th>
                    <th><?php esc_html_e( 'Created At', 'freepos' ); ?></th>
                    <th><?php esc_html_e( 'Status', 'freepos' ); ?></th>
                </tr>
            </thead>
            <tbody id="freepos-last-orders-body">
                <tr>
                    <td colspan="6"><?php esc_html_e( 'Loading...', 'freepos' ); ?></td>
                </tr>
            </tbody>
        </table>
    </div>

</div>
