<?php
/**
 * FreePOS Orders Page
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<div class="wrap freepos-orders-page">

    <h1><?php esc_html_e( 'POS Orders', 'freepos' ); ?></h1>

    <div class="freepos-orders-container">

        <!-- Top Toolbar -->
        <div class="freepos-orders-toolbar">

            <div class="left"></div>

            <div class="right">
                <div class="freepos-orders-search">
                    <span class="dashicons dashicons-search"></span>
                    <input type="text" id="freepos-orders-search-input" placeholder="<?php esc_attr_e( 'Search', 'freepos' ); ?>">
                </div>

                <button id="freepos-orders-refresh" class="button">
                    <span class="dashicons dashicons-update"></span>
                </button>

                <select id="freepos-orders-per-page">
                    <option value="10">10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                </select>

                <button id="freepos-orders-viewmode" class="button">
                    <span class="dashicons dashicons-menu"></span>
                </button>
            </div>
        </div>

        <!-- Orders Table -->
        <table class="widefat fixed striped freepos-orders-table">
            <thead>
                <tr>
                    <th><?php esc_html_e( 'ID', 'freepos' ); ?></th>
                    <th><?php esc_html_e( 'Customer', 'freepos' ); ?></th>
                    <th><?php esc_html_e( 'Date', 'freepos' ); ?></th>
                    <th><?php esc_html_e( 'Source', 'freepos' ); ?></th>
                    <th><?php esc_html_e( 'By', 'freepos' ); ?></th>
                    <th><?php esc_html_e( 'Total', 'freepos' ); ?></th>
                    <th><?php esc_html_e( 'Status', 'freepos' ); ?></th>
                </tr>
            </thead>
            <tbody id="freepos-orders-body">
                <tr>
                    <td colspan="7" class="no-results">
                        <?php esc_html_e( 'No results found!', 'freepos' ); ?>
                    </td>
                </tr>
            </tbody>
        </table>

        <!-- Pagination -->
        <div class="freepos-orders-pagination">
            <button class="button first-page">&laquo;</button>
            <button class="button prev-page">&lsaquo;</button>

            <span class="freepos-current-page">1</span>

            <button class="button next-page">&rsaquo;</button>
            <button class="button last-page">&raquo;</button>
        </div>

        <div class="freepos-orders-count">
            <?php esc_html_e( 'Showing 1 to 5 of 5 entries', 'freepos' ); ?>
        </div>

    </div>

</div>
