<?php
/**
 * FreePOS Settings Page
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

$pos_mode = get_option( 'freepos_pos_mode', 'grocery' );
?>
<div class="wrap freepos-settings-wrap">

    <h1><?php esc_html_e( 'FreePOS Settings', 'freepos' ); ?></h1>

    <!-- Tabs Navigation -->
    <div class="freepos-settings-tabs">
        <button class="tab active" data-tab="pos-mode">
            <span class="dashicons dashicons-store"></span>
            <?php esc_html_e( 'POS Mode', 'freepos' ); ?>
        </button>

        <button class="tab" data-tab="basic-settings">
            <span class="dashicons dashicons-admin-generic"></span>
            <?php esc_html_e( 'Basic Settings', 'freepos' ); ?>
        </button>

        <button class="tab" data-tab="print-settings">
            <span class="dashicons dashicons-printer"></span>
            <?php esc_html_e( 'Print Settings', 'freepos' ); ?>
        </button>

        <button class="tab" data-tab="sync-settings">
            <span class="dashicons dashicons-update-alt"></span>
            <?php esc_html_e( 'Sync Settings', 'freepos' ); ?>
        </button>

        <button class="tab" data-tab="security-settings">
            <span class="dashicons dashicons-shield"></span>
            <?php esc_html_e( 'Security', 'freepos' ); ?>
        </button>
    </div>


    <!-- TAB: POS MODE -->
    <div class="freepos-tab-content active" id="tab-pos-mode">

        <h2><?php esc_html_e( 'Choose POS Mode', 'freepos' ); ?></h2>

        <form method="post" action="options.php">
            <?php settings_fields( 'freepos_settings' ); ?>

            <input type="hidden" name="freepos_pos_mode" id="freepos_pos_mode" value="<?php echo esc_attr( $pos_mode ); ?>">

            <div class="freepos-mode-grid">

                <!-- Grocery Mode -->
                <div class="mode-card <?php echo $pos_mode === 'grocery' ? 'active' : ''; ?>"
                     data-mode="grocery">
                    <div class="icon"><span class="dashicons dashicons-cart"></span></div>
                    <div class="label"><?php esc_html_e( 'Grocery', 'freepos' ); ?></div>
                </div>

                <!-- Restaurant (Pay First) -->
                <div class="mode-card <?php echo $pos_mode === 'restaurant_payfirst' ? 'active' : ''; ?>"
                     data-mode="restaurant_payfirst">
                    <div class="icon"><span class="dashicons dashicons-food"></span></div>
                    <div class="label"><?php esc_html_e( 'Restaurant (Pay First)', 'freepos' ); ?></div>
                </div>

                <!-- Restaurant (Traditional) -->
                <div class="mode-card <?php echo $pos_mode === 'restaurant_traditional' ? 'active' : ''; ?>"
                     data-mode="restaurant_traditional">
                    <div class="icon"><span class="dashicons dashicons-groups"></span></div>
                    <div class="label"><?php esc_html_e( 'Restaurant (Traditional)', 'freepos' ); ?></div>
                </div>

                <!-- Restaurant (Basic) -->
                <div class="mode-card <?php echo $pos_mode === 'restaurant_basic' ? 'active' : ''; ?>"
                     data-mode="restaurant_basic">
                    <div class="icon"><span class="dashicons dashicons-smiley"></span></div>
                    <div class="label"><?php esc_html_e( 'Restaurant (Basic)', 'freepos' ); ?></div>
                </div>

            </div>

            <p class="submit">
                <button type="submit" class="button button-primary">
                    <?php esc_html_e( 'Save', 'freepos' ); ?>
                </button>
            </p>

        </form>

    </div>


    <!-- TAB: BASIC SETTINGS -->
    <div class="freepos-tab-content" id="tab-basic-settings">
        <h2><?php esc_html_e( 'Basic Settings', 'freepos' ); ?></h2>
        <p><?php esc_html_e( 'Additional settings will go here.', 'freepos' ); ?></p>
    </div>


    <!-- TAB: PRINT SETTINGS -->
    <div class="freepos-tab-content" id="tab-print-settings">
        <h2><?php esc_html_e( 'Print Settings', 'freepos' ); ?></h2>
        <p><?php esc_html_e( 'Thermal printer options, receipt customization, etc.', 'freepos' ); ?></p>
    </div>


    <!-- TAB: SYNC SETTINGS -->
    <div class="freepos-tab-content" id="tab-sync-settings">
        <h2><?php esc_html_e( 'Sync Settings', 'freepos' ); ?></h2>
        <p><?php esc_html_e( 'API sync, store sync, remote data sync options.', 'freepos' ); ?></p>
    </div>


    <!-- TAB: SECURITY SETTINGS -->
    <div class="freepos-tab-content" id="tab-security-settings">
        <h2><?php esc_html_e( 'Security Settings', 'freepos' ); ?></h2>
        <p><?php esc_html_e( 'Role permissions, cashier PINs, and POS access controls.', 'freepos' ); ?></p>
    </div>

</div>
