<?php
/**
 * FreePOS Transactions Page
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
?>

<div class="wrap freepos-transactions-page">

    <h1><?php esc_html_e( 'Transactions', 'freepos' ); ?></h1>

    <div class="freepos-transactions-container">

        <!-- Top Tabs -->
        <div class="freepos-transactions-tabs">
            <button class="tab active" data-type="all"><?php esc_html_e( 'All', 'freepos' ); ?></button>
            <button class="tab" data-type="custom"><?php esc_html_e( 'Custom transactions', 'freepos' ); ?></button>
        </div>

        <!-- Toolbar -->
        <div class="freepos-transactions-toolbar">

            <div class="left">
                <!-- Optional batch actions later -->
            </div>

            <div class="right">

                <div class="freepos-transactions-search">
                    <span class="dashicons dashicons-search"></span>
                    <input type="text" id="freepos-transactions-search-input"
                        placeholder="<?php esc_attr_e( 'Search', 'freepos' ); ?>">
                </div>

                <button id="freepos-transactions-refresh" class="button">
                    <span class="dashicons dashicons-update"></span>
                </button>

                <select id="freepos-transactions-per-page">
                    <option value="10">10</option>
                    <option value="25">25</option>
                    <option value="50">50</option>
                </select>

                <button id="freepos-transactions-viewmode" class="button">
                    <span class="dashicons dashicons-menu"></span>
                </button>

                <button id="freepos-transactions-delete" class="button">
                    <span class="dashicons dashicons-trash"></span>
                </button>

            </
