<?php
/**
 * Front-end POS screen template for FreePOS.
 *
 * Expected variables:
 * - string $pos_slug (current POS URL slug)
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

get_header();
?>
<main id="primary" class="freepos-pos-screen">
    <div class="wrap freepos-pos-wrap">
        <h1><?php esc_html_e( 'FreePOS – POS Screen', 'freepos' ); ?></h1>

        <p class="description">
            <?php
            printf(
                /* translators: %s: POS URL */
                esc_html__( 'You are viewing the POS screen at %s.', 'freepos' ),
                esc_html( home_url( '/' . $pos_slug . '/' ) )
            );
            ?>
        </p>

        <section class="freepos-pos-search">
            <h2><?php esc_html_e( 'Product Search', 'freepos' ); ?></h2>
            <form id="freepos-search-form">
                <label for="freepos-search-input">
                    <?php esc_html_e( 'Search products by name or SKU:', 'freepos' ); ?>
                </label>
                <input
                    type="text"
                    id="freepos-search-input"
                    name="s"
                    class="regular-text"
                    autocomplete="off"
                    placeholder="<?php esc_attr_e( 'Start typing to search…', 'freepos' ); ?>"
                />
            </form>

            <div id="freepos-search-status" class="freepos-search-status"></div>

            <table class="widefat striped freepos-search-results" id="freepos-search-results">
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'ID', 'freepos' ); ?></th>
                        <th><?php esc_html_e( 'Name', 'freepos' ); ?></th>
                        <th><?php esc_html_e( 'SKU', 'freepos' ); ?></th>
                        <th><?php esc_html_e( 'Price', 'freepos' ); ?></th>
                        <th><?php esc_html_e( 'Action', 'freepos' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="freepos-empty-row">
                        <td colspan="5">
                            <?php esc_html_e( 'No products found yet. Start typing to search.', 'freepos' ); ?>
                        </td>
                    </tr>
                </tbody>
            </table>
        </section>

        <section class="freepos-pos-cart">
            <h2><?php esc_html_e( 'Cart', 'freepos' ); ?></h2>

            <table class="widefat striped" id="freepos-cart-table">
                <thead>
                    <tr>
                        <th><?php esc_html_e( 'Product', 'freepos' ); ?></th>
                        <th><?php esc_html_e( 'SKU', 'freepos' ); ?></th>
                        <th><?php esc_html_e( 'Qty', 'freepos' ); ?></th>
                        <th><?php esc_html_e( 'Price', 'freepos' ); ?></th>
                        <th><?php esc_html_e( 'Subtotal', 'freepos' ); ?></th>
                        <th><?php esc_html_e( 'Remove', 'freepos' ); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="freepos-cart-empty">
                        <td colspan="6">
                            <?php esc_html_e( 'Your cart is empty.', 'freepos' ); ?>
                        </td>
                    </tr>
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="4" style="text-align:right;">
                            <?php esc_html_e( 'Total:', 'freepos' ); ?>
                        </th>
                        <th id="freepos-cart-total">0</th>
                        <th></th>
                    </tr>
                </tfoot>
            </table>

            <div class="freepos-cart-actions">
                <button type="button" id="freepos-cart-clear" class="button">
                    <?php esc_html_e( 'Clear Cart', 'freepos' ); ?>
                </button>
                <button type="button" id="freepos-cart-checkout" class="button button-primary" disabled>
                    <?php esc_html_e( 'Complete Sale (placeholder)', 'freepos' ); ?>
                </button>
            </div>

            <p class="description">
                <?php esc_html_e( 'Checkout / order creation will be wired up to WooCommerce and your payment gateways in a later step. For now, this is a working POS cart UI in the browser.', 'freepos' ); ?>
            </p>
        </section>
    </div>
</main>
<?php
get_footer();
